
!"Pocket Smalltalk fileout - 2003N68-15:26:47"!


!Object constantsFor: 'PalmOS Constants'!

sysFtrCreator 'psys'! !

!Object constantsFor: 'PalmOS: System Feature'!

sysFtrNumROMVersion 1! 
sysROMStageAlpha 1! 
sysROMStageBeta 2! 
sysROMStageDevelopment 0! 
sysROMStageRelease 3! !

!PalmOS class methodsFor: 'check version'!

isVersion30

	| minVersion currentVersion |

	minVersion := PalmOS osVersionFrom: #(3).
	currentVersion := PalmOS osVersion.
	currentVersion < minVersion
		ifTrue: [^false.].
	^true.
! !


!PalmOS class methodsFor: 'check version'!

isVersion35

	| minVersion currentVersion |

	minVersion := PalmOS osVersionFrom: #(3 5).
	currentVersion := PalmOS osVersion.
	currentVersion < minVersion
		ifTrue: [^false.].
	^true.
! !


!PalmOS class methodsFor: 'accessing'!

osVersion
	" ^ <LongInteger>
	representing the OS Version of your running device"
	
	SYSTRAP 
		FtrGet: (Integer fromBytes:##sysFtrCreator) 
		with: ##sysFtrNumROMVersion 
		with: PadBuffer.
	^PadBuffer dwordAt: 0! !


!PalmOS class methodsFor: 'accessing'!

osVersionString
	| str num |
	
	str := String new.
	num := self osVersion.
	str := ((num bitShift: -24) bitAnd: 255) printString , '.'. 
	str := str , ((num bitShift: -20) bitAnd: 15) printString , '.'. 
	str := str , ((num bitShift: -16) bitAnd: 15) printString , '.'. 
	str := str , ((num bitShift: -12) bitAnd: 15) printString , '.'. 
	str := str , (num bitAnd: 4095) printString.
	^str.	
! !


!PalmOS class methodsFor: 'accessing'!

osVersionFrom: anArray
	" ^ <LongInteger>
	representing the OS Version passed as parameter.
	[Companion, Vol 1]: A Palm OS version is defined with up to five parameters:
		major version number
		minor version number
		fix level
		build stage
		build number
	The fix and build numbers are normally 0 while build stage number is usually
	##sysROMStageRelease (See Constants in PalmOS: System Feature)"
	
	| major minor fix stage build |
	major := 2.
	minor := fix := build := 0.
	stage := ##sysROMStageRelease.
	anArray notEmpty ifTrue: [major := anArray at: 1].
	anArray size > 1 ifTrue: [minor := anArray at: 2].
	anArray size > 2 ifTrue: [fix := anArray at: 3].
	anArray size > 3 ifTrue: [stage := anArray at: 4].
	anArray size > 4 ifTrue: [build := anArray at: 5].
	 
	^self sysMakeROMVersion: major with: minor with:fix with: stage with: build
! !


!PalmOS class methodsFor: 'private'!

sysMakeROMVersion: aMajor with: aMinor with:aFix with: aStage with: aBuild
	" ^ <LongInteger>
	representing the version passed as argument. This is a C macro defined 
	in SystemMgr.h. Note that it is not a SYSTRAP"
	
	^((aMajor bitAnd: 255) bitShift: 24) bitOr: 
		(((aMinor bitAnd: 15) bitShift: 20) bitOr:  
			(((aFix bitAnd: 15) bitShift: 16) bitOr: 
				(((aStage bitAnd: 15) bitShift: 12) bitOr: 
					(aBuild bitAnd: 4095))))
! !


